
// modules

use crate::prelude::*;

use std::ops;

// types

#[derive(Clone, Copy, PartialEq, Eq, PartialOrd, Ord)]
pub struct Depth(pub i8); // negative for QS

impl Depth {

   pub fn from_int(d: u8) -> Self {
      debug_assert!(d < 128);
      Self(d as i8)
   }

   pub fn val(self) -> u8 {
      self.0.try_into().unwrap()
   }

   pub fn mul_shift(self, a: i16, b: u8) -> Self {
      Self(mul_shift(self.0.into(), a, b) as i8)
   }
}

impl From<Ply> for Depth {

   fn from(ply: Ply) -> Self {
      debug_assert!(ply < Ply(128));
      Self(ply.val() as i8)
   }
}

impl TryFrom<f32> for Depth {

   type Error = ();

   fn try_from(dr: f32) -> Result<Self, Self::Error> {
      let di = dr.round() as i32;
      Ok(Depth(i8::try_from(di).map_err(|e| ())?))
   }
}

impl From<Depth> for f32 {

   fn from(di: Depth) -> Self {
      Self::from(di.0)
   }
}

impl ops::Add for Depth {

   type Output = Self;

   fn add(self, rhs: Self) -> Self::Output {
      Self(self.0 + rhs.0)
   }
}

impl ops::AddAssign for Depth {

   fn add_assign(&mut self, rhs: Self) {
      *self = *self + rhs;
   }
}

impl ops::Sub for Depth {

   type Output = Self;

   fn sub(self, rhs: Self) -> Self::Output {
      Self(self.0 - rhs.0)
   }
}

impl ops::SubAssign for Depth {

   fn sub_assign(&mut self, rhs: Self) {
      *self = *self - rhs;
   }
}

impl ops::Mul<i16> for Depth {

   type Output = i16;

   fn mul(self, rhs: i16) -> Self::Output {
      self.0 as i16 * rhs
   }
}

fn mul_shift(a: i16, b: i16, c: u8) -> i16 {
   debug_assert!(b > 0 && b < (1 << c));
   (a * b + (1 << (c - 1))) >> c
}

