
// modules

use std::ops;

// types

pub trait Num : Copy + PartialEq + PartialOrd + Default + ops::Add<Output = Self> + ops::Sub<Output = Self> + ops::Mul<Output = Self> {
   const Zero: Self;
   const One:  Self;
}

pub trait Int : Num + Eq + Ord + TryInto<u64> + TryInto<i64> {

   fn rev(self, size: Self) -> Self {
      debug_assert!(self >= Self::Zero && self < size);
      (size - Self::One) - self
   }
}

pub trait Real : Num + ops::Neg<Output = Self> + ops::Div<Output = Self> {}

// functions

pub fn lerp<R: Real>(a: R, b: R, t: R) -> R {
   debug_assert!(t >= R::Zero && t <= R::One);
   a + (b - a) * t
}

impl Num for u8 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for i8 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for u16 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for i16 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for u32 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for i32 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for u64 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for i64 {
   const Zero: Self = 0;
   const One:  Self = 1;
}

impl Num for f32 {
   const Zero: Self = 0.0;
   const One:  Self = 1.0;
}

impl Num for f64 {
   const Zero: Self = 0.0;
   const One:  Self = 1.0;
}

impl Int for u8 {}

impl Real for f32 {}

