
// modules

use std::collections::HashMap;

// types

pub struct Var(HashMap<String, String>);

// functions

impl Var {

   pub fn new() -> Self {
      Self(HashMap::new())
   }

   pub fn get(&self, name: &str) -> String {

      match self.0.get(name) {
         None => panic!("unknown variable '{name}'"),
         Some(value) => value.clone(),
      }
   }

   pub fn set(&mut self, name: &str, value: &str) {
      self.0.insert(name.to_owned(), value.to_owned());
   }
}

impl Default for Var {

   fn default() -> Self {
      Self::new()
   }
}

